<?php
/* --------------------------------------------------------------
 ApiBootstrapper.php 2020-05-04
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Api\Application\Kernel;

use Gambio\Api\Application\Kernel\Bootstrapper\ApiErrorHandlerRegistration;
use Gambio\Api\Application\Kernel\Bootstrapper\ApiRoutesRegistration;
use Gambio\Api\Application\Kernel\Bootstrapper\ApiServiceProviderRegistration;
use Gambio\Api\Application\Kernel\Bootstrapper\LoadAdminShopConfiguration;
use Gambio\Core\Application\Application;
use Gambio\Core\Application\Kernel\AbstractBootstrapper;
use Gambio\Core\Application\Kernel\Bootstrapper;
use Gambio\Core\Application\Kernel\Bootstrapper\CommandDispatcherRegistration;
use Gambio\Core\Application\Kernel\Bootstrapper\CoreServiceProviderRegistration;
use Gambio\Core\Application\Kernel\Bootstrapper\EventDispatcherRegistration;
use Gambio\Core\Application\Kernel\Bootstrapper\RoutingMiddlewareRegistration;
use Gambio\Core\Application\Kernel\Bootstrapper\SlimAppRegistration;

/**
 * Class ApiBootstrapper
 * @package Gambio\Api\Application\Kernel
 */
class ApiBootstrapper extends AbstractBootstrapper
{
    /**
     * Defines the current API version.
     */
    public const VERSION = '3.0.0';
    
    /**
     * Defines the sub bootstrapper used for the API
     */
    private const SUB_BOOTSTRAPPER = [
        LoadAdminShopConfiguration::class,
        EventDispatcherRegistration::class,
        CommandDispatcherRegistration::class,
        
        CoreServiceProviderRegistration::class,
        ApiServiceProviderRegistration::class,
        
        SlimAppRegistration::class,
        RoutingMiddlewareRegistration::class,
        ApiErrorHandlerRegistration::class,
        
        ApiRoutesRegistration::class,
    ];
    
    
    /**
     * @inheritDoc
     */
    public function boot(Application $application): void
    {
        foreach (self::SUB_BOOTSTRAPPER as $bootstrapper) {
            /** @var Bootstrapper $instance */
            $instance = new $bootstrapper;
            $instance->boot($application);
        }
    }
}